/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.util;

import de.unhappycodings.quarry.common.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class CalcUtil {
    public static List<BlockPos> getBlockStates(BlockPos loc1, BlockPos loc2, Level level) {
        int zMax;
        int yMin;
        int xMax;
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        int x1 = loc1.m_123341_();
        int y1 = loc1.m_123342_();
        int z1 = loc1.m_123343_();
        int x2 = loc2.m_123341_();
        int y2 = loc2.m_123342_();
        int z2 = loc2.m_123343_();
        if (x1 > x2) {
            xMin = x2;
            xMax = x1;
        } else {
            xMin = x1;
            xMax = x2;
        }
        if (y1 > y2) {
            yMin = y2;
            yMax = y1;
        } else {
            yMin = y1;
            yMax = y2;
        }
        if (z1 > z2) {
            zMin = z2;
            zMax = z1;
        } else {
            zMin = z1;
            zMax = z2;
        }
        for (int y = yMax; y >= yMin; --y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    blocks.add(new BlockPos(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static int getBlockCount(BlockPos pos1, BlockPos pos2) {
        int x1 = pos1.m_123341_();
        int y1 = pos1.m_123342_();
        int z1 = pos1.m_123343_();
        int x2 = pos2.m_123341_();
        int y2 = pos2.m_123342_();
        int z2 = pos2.m_123343_();
        if (y1 > 320) {
            y1 = 320;
        }
        if (y1 < -64) {
            y1 = -64;
        }
        if (y2 > 320) {
            y2 = 230;
        }
        if (y2 < -64) {
            y2 = -64;
        }
        return Math.abs((x1 - x2 + 1) * (y1 - y2 + 1) * (z1 - z2 + 1));
    }

    public static float getNeededTicks(int mode, int speed) {
        int fuelModifier = switch (mode) {
            case 1 -> (Integer)CommonConfig.quarryEfficientModeConsumption.get();
            case 2 -> (Integer)CommonConfig.quarryFortuneModeConsumption.get();
            case 3 -> (Integer)CommonConfig.quarrySilkTouchModeConsumption.get();
            case 4 -> (Integer)CommonConfig.quarryVoidModeConsumption.get();
            default -> (Integer)CommonConfig.quarryDefaultModeConsumption.get();
        };
        switch (speed) {
            case 0: {
                fuelModifier = (int)((double)fuelModifier * (Double)CommonConfig.quarrySpeedOneModifier.get());
                break;
            }
            case 1: {
                fuelModifier = (int)((double)fuelModifier * (Double)CommonConfig.quarrySpeedTwoModifier.get());
                break;
            }
            case 2: {
                fuelModifier = (int)((double)fuelModifier * (Double)CommonConfig.quarrySpeedThreeModifier.get());
                break;
            }
            case 3: {
                fuelModifier = (int)((double)fuelModifier * (Double)CommonConfig.quarrySpeedFourModifier.get());
            }
        }
        return fuelModifier;
    }
}

